/*
 * main.cpp
 *
 *  Created on: Apr 8, 2012
 *      Author: linh, UC Davis
 */


#include <stdio.h>
#include <iostream>
#include <fstream>
#include <string>
#include <math.h>
#include <stdlib.h>
#include <time.h>
#include <ctime>

#include "DesignProblem.h"
#include "PartDatabase.h"
#include "Framework.h"

using namespace std;

void Multiplexer() {
	PartDatabase* pdb = new PartDatabase("Database/CAD_Mini");
	DesignProblem dp("Database/multiplexer2.txt");
	//dp.TestPrint(&std::cout);
	Framework framework(pdb,dp);
	//framework.ModuleMatch(100,0);
	framework.Optimize();
}

void Scalability() {
	PartDatabase* pdb = new PartDatabase("Database/CAD");
	Framework framework(pdb);

	srand(time(NULL));
	int number_of_replicates = 5;
	int scale = 5; // we will check 5, 10, 15, 20, 25 and 30 gates
	for (int size = 1; size <= 6; size++){
		for (int rep = 0; rep < number_of_replicates; rep++)
			framework.Scalability(scale*size,2*size + 1,size,1000,1000);
		cout << endl;
	}
	cout << "---------------------" << endl;
	for (int size = 1; size <= 6; size++){
		for (int rep = 0; rep < number_of_replicates; rep++)
			framework.Scalability(scale*size,2*size + 1,size,2000,1000);
		cout << endl;
	}
	cout << "---------------------" << endl;
	for (int size = 1; size <= 6; size++){
		for (int rep = 0; rep < number_of_replicates; rep++)
			framework.Scalability(scale*size,2*size + 1,size,4000,1000);
		cout << endl;
	}
	cout << "---------------------" << endl;
}

int main() {
	cout << "START" << endl;
	Multiplexer();
	//Scalability();
	cout << "FINISHED :-)" << endl;
}
